#include <stdio.h>

int main() {
    char user_type;
    float litres, bill, surcharge = 0.0;

    // Input
    printf("Enter user type (H for Household, C for Commercial): ");
    scanf(" %c", &user_type);

    printf("Enter water consumption in litres: ");
    scanf("%f", &litres);

    // Calculate base bill according to slab
    if (litres <= 5000)
        bill = litres * 0.10;
    else if (litres <= 20000)
        bill = 5000 * 0.10 + (litres - 5000) * 0.15;
    else
        bill = 5000 * 0.10 + 15000 * 0.15 + (litres - 20000) * 0.25;

    // Apply surcharge for commercial users
    if (user_type == 'C' || user_type == 'c') {
        surcharge = bill * 0.25;
        bill += surcharge;
    }

    // Display the result
    printf("\n--- Water Bill Summary ---\n");
    printf("User Type       : %s\n", (user_type == 'H' || user_type == 'h') ? "Household" : "Commercial");
    printf("Consumption     : %.2f litres\n", litres);
    printf("Surcharge       : BDT %.2f\n", surcharge);
    printf("Total Bill      : BDT %.2f\n", bill);

    return 0;
}
